# Loose Notes on my experiences with ZFS
## current experiences with holding the data of the archive
- Deduplication together with a full drive kills deletion performance
- Size of deduplication tables: 376 GB On Disk, 80 GB in core
- Make separate ZIL 4 times as large as maximum expected write load (2 for two TXGs +2 for safety)
- setting the record size from 128 KB to 1MB improves the compression.

links:
https://github.com/openzfs/zfs/issues/1709

https://www.reddit.com/r/sysadmin/comments/5isqmi/anyone_with_successful_large_zfs_dedup/



## Notes for a new /archive setup
- BtrFS Status page https://btrfs.wiki.kernel.org/index.php/Status#Out_of_band_dedupe
- Use ZStd compression: 
- Out-of-band deduplication: https://btrfs.wiki.kernel.org/index.php/Deduplication
- If an open_ctree error happens on startup this could be due to systemd killing the mount process. the mount of the 80TB FS is taking longer than 10mins.

## /home
- initial sync via 1GB NFS: 1468 minutes.
- resync: 82mins
- We will try to use NFS v4.2 for /home. Proper UID/Username mapping across computers can only be done via Kerberos.
- NFS4.2 does not seem to require any special fiddling except enforcing it at mount.
- We use a mirrored special(mostly for metadata) device. 33T of data require 286 GB of space here. With the current layout, there is 22 GB of spare space on the SSDs. We should increase the spare area to 40GB.
- With the intended redundancy level, 33TB of data(from /archive) take up around 290 GB on the special device, which is used for metadata caching

- Bullseye has issues with the maintenance of the bonding driver. The teaming driver works with 2GBit/s but a stable connection.
- Quota will be different... there'S the ZFS quota and the posix quota.
- Useful command to get all info: zfs userspace theohome
- setting quotas: zfs set userquota@trauzett=30G theohome