# NetCDF
NetCDF can use two/three internal formats. In NetCDF4 exists an HDF5 backend 
where the output is a valid NetCDF4 file as well as a valid HDF5 file.
The NetCDF possibilities are more limited than HDF5 where now in turn a simpler
interface results.
NetCDF4 files are readable by Mathematica, Matlab, octave, origin, igor pro, [Excel](http://netcdf4excel.github.io/),
Labview, IDL, and [lots of other tools](https://www.unidata.ucar.edu/software/netcdf/software.html):

Parallel I/O available via the parallel I/O of HDF5.

File Creation:
There are two modes: Define mode and put mode. By default if you create a file it's in define mode

properties of variables can be inquired using nf90_inquire_variable .
dimensions are handled via a second indirection. 
First you query the dimension ids via a call to nf90_inquire_variable 
and then for each dimension id you query the actual value via nf90_inquire_dimension

This sounds useful if you store label information, or the units of a quantity, for each dimension in the file.

Compound Data Types (C structs) are possible in HDF5 backend format only.

HDF5: h5utils

import the dataset with the name "matrix" in Mathematica:
Import["/home/sifff/Desktop/cmckee-reordering/mat.nc", {"Datasets", "matrix"}]

## conversion
Converting an HDF5 file to a NetCDF4

nccopy in.h5 out.nc

Converting FITS(used in astronomy) there is a [tool](https://arxiv.org/abs/1505.06421)

## Dumping the written file
h5dump <file>

## Python
Use the NetCDF4 module (see examples)

or directly into [pandas](https://stackoverflow.com/questions/14035148/import-netcdf-file-to-pandas-dataframe) via the xarray module.

You can also use [h5py](https://www.h5py.org/), since netCDF files are valid HDF5 files,
here's a [tutorial](https://www.pythonforthelab.com/blog/how-to-use-hdf5-files-in-python/)
## Examples
### C
Examples reading and writing with the C API: [reading](netcdf_c_read.cpp), [writing](netcdf_c_write.cpp)
### Python
[Writing](write_netcdf.py) a NetCDF4 file.
### Fortran
An example function is [here](netcdf_f90_ex.F90) You can compare a functionally identical function using HDF5.

### Debian Packages
libnetcdf-dev
As already stated the h5utils package is useful