#include <cstdlib>
#include <cstdio>
#include <netcdf.h>

int main()
{
    char filename[] = "mat.nc";
    int ncid;
    // open the file. NC_NOWRITE tells netcdf that we want read-oly
    int retval = nc_open(filename, NC_NOWRITE, &ncid);
    // we know there is a dataset called "matrix" so let's retrieve that
    int varid;
    retval = nc_inq_varid(ncid, "mymatrix", &varid);
    //now we have the id -> query dimensionality
    int rank;
    retval = nc_inq_varndims(ncid, varid, &rank);
    int* dimids = new int[rank];
    size_t* dimlens = new size_t[rank];
    retval = nc_inq_vardimid(ncid, varid, dimids);
    for (int i = 0; i < rank; ++i)
        retval = nc_inq_dimlen(ncid, dimids[i], &(dimlens[i]));
    printf("%zi %zi\n", dimlens[0], dimlens[1]);
    double* data = new double[dimlens[0]*dimlens[1]];

    //read the entire matrix
    retval = nc_get_var_double(ncid, varid, data);
    //dump data
    for (int i = 0; i < dimlens[0]*dimlens[1]; ++i)
	printf("%e\n", data[i]);
	//tidy up
    nc_close(ncid);
    delete [] data;
    delete [] dimids;
    delete [] dimlens;
}
