#include <cstdlib>
#include <cstdio>
#include <netcdf.h>

int main()
{
char filename[]="mat.nc";
int rank = 2;
int dim[2] = {57, 7};
int dimid[2] = {0};
int ncid;
// set up some sample data
double* data = new double[dim[0]*dim[1]];
for (int i = 0; i < dim[0]; ++i)
    for(int j = 0; j < dim[1]; ++j)
        data[i*dim[1] + j] = i+j;
    // open the file in NetCDF4 -> HDF5 format but still enforce the old classic model.
    int retval = nc_create(filename, NC_CLOBBER | NC_NETCDF4 | NC_CLASSIC_MODEL, &ncid);
//netcdf is now by default in define mode, s let's define our data
// first the dimensionality
    retval = nc_def_dim(ncid, "temperature", dim[0], dimid);
    retval = nc_def_dim(ncid, "energy", dim[1], &(dimid[1]));
    //next comes the data type
    int varid;
    retval = nc_def_var(ncid, "mymatrix", NC_DOUBLE, rank, dimid, &varid);
    
    //enable deflate compression
    nc_def_var_deflate(ncid, varid, 1/*enable shuffle filter*/, 1/*enable deflate*/, 9/*compression strength*/);
    //end define mode
    retval = nc_enddef(ncid);
    // last index of the dimension array varies fastest
    retval = nc_put_var_double(ncid, varid, data);
    nc_close(ncid);
delete [] data;
}
