# Singularity
*   [Singularity](#singularity)
    *   [Advantages of Singularity](#advantages-of-singularity)
    *   [Disadvantages](#disadvantages)
    *   [Quick guide](#quick-guide)
*   [Creation of own containers](#creation-of-own-containers)
    *   [The Singularity file](#the-singularity-file)
    *   [Trigger the creation](#trigger-the-creation)
    *   [Other possibilities of note:](#other-possibilities-of-note)
        *   [Singularity Hub](#singularity-hub)
        *   [Gitlab-CI](#gitlab-ci)
        *   [Existing Docker Images](#existing-docker-images)
        *   [Further info](#Further-info)
*   [Executing something in the environment](#executing-something-in-the-environment)
    *   [Commands](#commands)
    *   [Files and Folders:](#files-and-folders)
*   [Julia vs. Singularity](#julia-vs-singularity)
*   [Computing Architecture corner](#computing-architecture-corner)
    *   [(WIP) MPI](#wip-mpi)
    *   [MICs and GPUs](#mics-and-gpus)
*   [Outlook](#outlook)
    *   [Apps](#apps)
*   [Resources](#Resources)

### Advantages of Singularity
A nice article by the authors is [here](http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0177459)
- BYOE (Bring your own environment)
- thus reproducibility
- strong tendency to scripts
- enables transport of environments from one HPC center to the next
- secure: you are the same user in the container as outside -> therefore common unix user protection applies.

### Disadvantages
Still no container creation without some form of root access.
### Quick guide
Execute a single binary myprog.exe in the container:
```
singularity exec image.simg myprog.exe
```
Create basic debian-9 based image:
```
mkdir myimage && cd myimage && touch Singularity.def
```
Then copy this script to a file like "Singularity.def"
```
BootStrap: debootstrap
OSVersion: stable
MirrorURL: http://agspanier.astro.uni-wuerzburg.de/debian

%runscript
    echo "This is what happens when you run the container..."

%post
    echo "Hello from inside the container"
    apt-get update
    apt-get -y install vim
apt-get clean
```
and then(v 2.4) 
```
sudo singularity build mycontainer.img Singularity.def
```
## Creation of own containers
Singularity forces a separation between a build development environment, where you need to have at least sudo access(or you use the singularity build hub)
![singularity flow](http://singularity.lbl.gov/assets/img/diagram/singularity-2.4-flow.png)

By design singularity containers are immutable, hence cannot be changed after creation.
This ensures a reproducible scientific software stack.
We will begin with how to build our first container.
To that end we should create a new folder, let's call it 'image1'
and then we create the so-called Singularity file with the name "Singularity" in it.
### The Singularity file
Just as there is the Dockerfile in docker to specify how a container is built, there is the Singularity file 
in singularity. It is Singularity with a capital 'S'.
'#' denotes comments just as in the bash.
For some basic usage it follows the following structure which
shows the usage on how to build a Debian-9 based system.
I have added some comments to it to help you.
```
# First we have the header
BootStrap: debootstrap
OSVersion: stable
MirrorURL: http://agspanier.astro.uni-wuerzburg.de/debian

# And then come various sections. Each section is introduced with the 
# '%' symbol.

%environment
# Here you can define environment variables that should be available to your code 
# when executing the runscript. It also makes life a little bit easier to add the path
# of your binary to the PATH variable:
# NOTE: only present in V2.3+ in 2.2 you have to do this in the runscript.
PATH=$PATH:/myfancyapp

%files
# Here you can specify files that should be available at the execution of your post script.
# They will get copied to the path in the container that you specify as the second argument
# (/tmp in the example below)
# A common use case is to copy the source of your code into the container.
# NOTE for v2.2: you should use %setup instead of %files and plain cp ...
/home/user/myprog.tar.gz /tmp

%runscript
# This part gets executed if you do "singularity run ..."
# Note that command line arguments to the singularity container
# get passed to this script
    echo "This is what happens when you run the container..."

%post
# This part gets executed after the setup of the base system that you have specified in the header.
# So this is the part where you install packages and compile your source code.
    echo "Hello from inside the container"
    apt-get update
    apt-get -y install vim
    apt-get clean
```
This script is the bootstrapping script for various debian based systems that use debootstrap.
It is possible to use(depending on the singularity version.) 
- shub (images hosted on Singularity Hub)
- docker (images hosted on Docker Hub)
- localimage (images saved on your machine)
- yum (yum based systems such as CentOS and Scientific Linux)
- debootstrap (apt based systems such as Debian and Ubuntu)
- arch (Arch Linux)
- busybox (BusyBox)
- zypper (zypper based systems such as Suse and OpenSuse)

Each of these have their own [pecularities](https://www.sylabs.io/guides/2.5.1/user-guide/container_recipes.html#header) for the configuration.
Note that most likely you need some package tools installed to get it working, as e.g. debootstrap on a debian system.
Examples for various unices can be found [here](https://github.com/singularityware/singularity/tree/master/examples) or in the images by [Thorsten Ohl](https://git.physik.uni-wuerzburg.de/itpa-computers/singularity)

### Trigger the creation
Assuming you have written a Singularity file you can (depending on the version)
trigger the creation of the image.
For Singularity v2.2 (Debian-9 default)
- start with an empty folder(DO NOT USE /home, suid vs. NFS) mkdir test && cd test
- Prepare an image: sudo singularity create mydeb.img
- Bootstrap it(debootstrap needs to be installed) sudo singularity bootstrap mydeb.img Singularity 

For Singularity 2.5:
You may not be in /home and you need debootstrap installed
sudo singularity build mydeb2.img Singularity 

In 2.5 you have the possibility to start from existing docker containers.

### Other possibilities of note:
#### Singularity Hub
https://github.com/singularityhub/singularityhub.github.io/wiki
It is possible to set up an own singularity-hub server.

#### Gitlab-CI
Here's a tutorial and a repo on how to use gitlab-CI to obtain singularity containers:
https://gitlab.com/singularityhub/gitlab-ci

#### existing docker images
(works only if singularity version is bigger than 2.4)
singularity pull docker://git.physik.uni-wuerzburg.de:25812/z03/pdi:debian-jessie-blas
It is important to prefix the url with docker://
This creates a .shub file in the current directory. This is the native format of singularity.

#### Further info
http://singularity.lbl.gov/docs-flow

## Executing something in the environment
Now you have the Singularity file and the associated image. Now you want to execute something in it.
### Commands
If you want to execute a single program in the environment of the container, you use exec:
```
singularity exec ./pdi-debian-jessie-blas.simg cat /etc/debian_version 
```

open a bash 
```
singularity shell ./pdi-debian-jessie-blas.simg
```
Another(not so good opportunity):

singularity run ./pdi-debian-jessie-blas.simg

you instantly have the same user and group as outside of the environment as well as your home directory,
e.g.

singularity exec ./pdi-debian-jessie-blas.simg ls $HOME

singularity-2.4+ is also able to instantly use docker images.
https://www.sylabs.io/guides/2.5.1/user-guide/singularity_and_docker.html#

### Files and Folders
By default singularity bind mounts /home/$USER, /tmp, and $PWD into your container at runtime.

## Julia vs. Singularity
Sample SLURM Script from Thorsten Ohl:
```
! /bin/sh
#SBATCH --time=1
sy="singularity exec $HOME/images/debian.simg"
$sy uname -a
$sy cat /etc/debian_version
$sy dpkg --get-selections | grep -v 'deinstall$'
$sy apt-mark showauto
$sy apt-mark showmanual
```

## Computing Architecture corner
### (WIP) MPI
Open MPI must be newer or equal to the version inside the container.
http://singularity.lbl.gov/archive/docs/v2-3/faq#why-do-we-call-mpirun-from-outside-the-container-rather-then-inside

always call mpirun outside of the container:
```
mpirun -np 4 singularity exec /tmp/Centos-7.img /usr/bin/mpi_ring
```
You need at least OpenMPI-2.1 inside and outside of the container. Debian-9 has by default only 2.0 and hence will not work reliably.
Try to create an Ubuntu container instead.
### MICs and GPUs 
doable, see the resources.

## Outlook
### Apps
You can offer to run multiple programs from a single container.
This concept is called apps and available in Singularity-2.4. [Docs are here](https://www.sylabs.io/guides/2.5.1/user-guide/container_recipes.html#apps)

## Resources
https://www.intel.com/content/dam/www/public/us/en/documents/presentation/hpc-containers-singularity-advanced.pdf

http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0177459

https://www.sylabs.io/guides/2.5.1/user-guide/

[https://www.westgrid.ca/files/WG%20singularity%20Nov21.pdf](https://www.westgrid.ca/files/WG%20singularity%20Nov21.pdf)
